/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;

public class FireParameterOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private Parameter parameter;
    private final double[] values;

    public FireParameterOperator(Parameter parameter, double[] dArray, double d) {
        this.parameter = parameter;
        this.values = dArray;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return "fireParameterChanged";
    }

    @Override
    public double doOperation() {
        if (this.values != null) {
            for (int i = 0; i < this.parameter.getDimension(); ++i) {
                this.parameter.setParameterValueQuietly(i, this.values[i]);
            }
            this.parameter.fireParameterChangedEvent();
        } else {
            this.parameter.setParameterValue(0, this.parameter.getParameterValue(0));
        }
        return 0.0;
    }

    public int getStepCount() {
        return 1;
    }
}

