/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.oldevomodel.substmodel.AbstractSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;

public class GeneralF81Model
extends AbstractSubstitutionModel {
    public GeneralF81Model(FrequencyModel frequencyModel) {
        super("generalF81", frequencyModel.getDataType(), frequencyModel);
        this.setupMatrix();
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        int n;
        int n2 = this.freqModel.getFrequencyCount();
        double[] dArray2 = this.freqModel.getFrequencies();
        double d2 = 1.0;
        double[] dArray3 = dArray2;
        int n3 = dArray3.length;
        for (n = 0; n < n3; ++n) {
            double d3 = dArray3[n];
            d2 -= d3 * d3;
        }
        d2 = 1.0 / d2;
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            for (n = 0; n < n2; ++n) {
                dArray[n4] = n3 == n ? dArray2[n3] + (1.0 - dArray2[n3]) * Math.exp(-d2 * d) : dArray2[n] * (1.0 - Math.exp(-d2 * d));
                ++n4;
            }
        }
    }

    @Override
    protected void setupRelativeRates() {
    }

    @Override
    public void storeState() {
        super.storeState();
    }

    @Override
    public void restoreState() {
        super.restoreState();
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>General F81 Model</em>");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        GeneralDataType generalDataType = new GeneralDataType(new String[]{"0", "1", "2"});
        FrequencyModel frequencyModel = new FrequencyModel((DataType)generalDataType, new double[]{0.2, 0.3, 0.5});
        GeneralF81Model generalF81Model = new GeneralF81Model(frequencyModel);
        int n = generalDataType.getStateCount();
        double[] dArray = new double[n * n];
        generalF81Model.getTransitionProbabilities(0.01, dArray);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            System.out.print(dArray[n2]);
            double d = dArray[n2];
            ++n2;
            for (int j = 1; j < n; ++j) {
                System.out.print(", " + dArray[n2]);
                d += dArray[n2];
                ++n2;
            }
            System.out.println(" : " + d);
        }
    }
}

