% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{plot_mesh}
\alias{plot_mesh}
\title{plot mesh}
\usage{
plot_mesh(
  surface_mesh,
  density_color = NULL,
  title = NULL,
  legend = TRUE,
  legend_color_sel = NULL,
  legend_maxi = 2000,
  legend_mini = 0,
  userMat = NULL
)
}
\arguments{
\item{surface_mesh}{Mesh object}

\item{density_color}{Vector. Colors mapped from density values.}

\item{title}{String. Plot title.}

\item{legend}{Logical. Optional color bar.}

\item{legend_color_sel}{Optional character with color gradient}

\item{legend_maxi}{Numeric. Maximum bone density.}

\item{legend_mini}{Numeric. Minimum bone density.}

\item{userMat}{Optional matrix. Controls graph orientation.}
}
\value{
plot of mesh with color
}
\description{
plot mesh
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.1/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  nifti <- import_scan(scan_filepath)
  url2 <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url2, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  vertices <- t(surface_mesh$vb)[, c(1:3)]
  landmark_path <- system.file("extdata", "test_femur.mrk.json",
                               package = "BoneDensityMapping")
  landmarks <- import_lmks(landmark_path)
  mapped_coords <- surface_points_template(surface_mesh, landmarks,
                                           no_surface_sliders = 5000)
  mat_peak <- surface_normal_intersect(surface_mesh, mapped_coords,
                                       normal_dist = 3.0, nifti, rev_y=FALSE)
  color_mesh <- color_mesh(surface_mesh, mapped_coords, mat_peak, maxi = 2000,
                           mini = 0)
  plot <- plot_mesh(color_mesh)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
