% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{plot.Boruta}
\alias{plot.Boruta}
\title{Plot Boruta object}
\usage{
\method{plot}{Boruta}(
  x,
  colCode = c("green", "yellow", "red", "blue"),
  sort = TRUE,
  whichShadow = c(TRUE, TRUE, TRUE),
  col = NULL,
  xlab = "Attributes",
  ylab = "Importance",
  ...
)
}
\arguments{
\item{x}{an object of a class Boruta.}

\item{colCode}{a vector containing colour codes for attribute decisions, respectively Confirmed, Tentative, Rejected and shadow.}

\item{sort}{controls whether boxplots should be ordered, or left in original order.}

\item{whichShadow}{a logical vector controlling which shadows should be drawn; switches respectively max shadow, mean shadow and min shadow.}

\item{col}{standard \code{col} attribute. If given, suppresses effects of \code{colCode}.}

\item{xlab}{X axis label that will be passed to \code{\link{boxplot}}.}

\item{ylab}{Y axis label that will be passed to \code{\link{boxplot}}.}

\item{...}{additional graphical parameter that will be passed to \code{\link{boxplot}}.}
}
\value{
Invisible copy of \code{x}.
}
\description{
Default plot method for Boruta objects, showing boxplots of attribute importances over run.
}
\note{
If \code{col} is given and \code{sort} is \code{TRUE}, the \code{col} will be permuted, so that its order corresponds to attribute order in \code{ImpHistory}.

This function will throw an error when \code{x} lacks importance history, i.e., was made with \code{holdHistory} set to \code{FALSE}.
}
\examples{
\dontrun{
library(mlbench); data(HouseVotes84)
na.omit(HouseVotes84)->hvo
#Takes some time, so be patient
Boruta(Class~.,data=hvo,doTrace=2)->Bor.hvo
print(Bor.hvo)
plot(Bor.hvo)
}
}
