% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime-package.R
\docType{package}
\name{CFtime-package}
\alias{CFtime-package}
\title{CFtime: working with CF Metadata Conventions "time" dimensions}
\description{
Support for all calendars as specified in the Climate and Forecast
(CF) Metadata Conventions for climate and forecasting data. The CF Metadata
Conventions is widely used for distributing files with climate observations
or projections, including the Coupled Model Intercomparison Project (CMIP)
data used by climate change scientists and the Intergovernmental Panel on
Climate Change (IPCC). This package specifically allows the user to work
with any of the CF-compliant calendars (many of which are not compliant with
POSIXt). The CF time coordinate is formally defined in the
\href{https://cfconventions.org/Data/cf-conventions/cf-conventions-1.12/cf-conventions.html#time-coordinate}{CF Metadata Conventions document}.
}
\details{
This package also supports the creation of a "time" dimension, using class
\code{CFClimatology}, for climatological statistics as defined \href{https://cfconventions.org/Data/cf-conventions/cf-conventions-1.12/cf-conventions.html#climatological-statistics}{here}.

The package can create a \link{CFTime} or \link{CFClimatology} instance from scratch or, more commonly, it
can use the dimension attributes and dimension variable values from a netCDF
resource. The package does not actually do any of the reading and the user is
free to use their netCDF package of preference. The recommended package to
use (with any netCDF resources) is \href{https://cran.r-project.org/package=ncdfCF}{ncdfCF}.
\code{ncdfCF} will automatically use this package to manage the "time" dimension
of any netCDF resource. As with this package, it reads and interprets the
attributes of the resource to apply the CF Metadata Conventions, supporting
axes, auxiliary coordinate variables, coordinate reference systems, etc.
Alternatively, for more basic netCDF reading and writing, the two main options
are \href{https://cran.r-project.org/package=RNetCDF}{RNetCDF} and
\href{https://cran.r-project.org/package=ncdf4}{ncdf4}).

\strong{Create, modify, inquire}
\itemize{
\item \code{\link[=CFtime]{CFtime()}}: Create a \link{CFTime} instance
\item \code{\link[=properties]{Properties}} of the \code{CFTime} instance
\item \code{\link[=parse_timestamps]{parse_timestamps()}}: Parse a vector of character timestamps into \code{CFTime} elements
\item \code{\link[=CFtime-equivalent]{Compare}} two \code{CFTime} instances
\item \code{\link[=CFtime-merge]{Merge}} two \code{CFTime} instances or append additional time steps to a \code{CFTime} instance
\item \code{\link[=as_timestamp]{as_timestamp()}} and \code{\link[=format]{format()}}: Generate a vector of character or \code{POSIXct} timestamps from a \code{CFTime} instance
\item \code{\link[=range]{range()}}: Timestamps of the two endpoints in the time series
\item \code{copy()}: Create a copy of a CFTime instance
\item \code{subset()}: Create a new CFTime instance which is a subset by index positions of another CFTime instance
\item \code{\link[=is_complete]{is_complete()}}: Does the \code{CFTime} instance have a complete time series between endpoints?
\item \code{\link[=month_days]{month_days()}}: How many days are there in a month using the calendar of the \code{CFTime} instance?
}

\strong{Factors and coverage}
\itemize{
\item \code{\link[=CFfactor]{CFfactor()}} and \code{\link[=cut]{cut()}}: Create factors for different time periods
\item \code{\link[=CFfactor_units]{CFfactor_units()}}: How many units of time are there in each factor level?
\item \code{\link[=CFfactor_coverage]{CFfactor_coverage()}}: How much data is available for each level of the factor?
}

\strong{Filtering and selection}
\itemize{
\item \code{\link[=slice]{slice()}}: Logical vector of time steps between two extreme points.
\item \code{\link[=indexOf]{indexOf()}}: Index values in the time series of given timestamps, possibly with
fractional part for interpolation.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/R-CF/CFtime}
  \item Report bugs at \url{https://github.com/R-CF/CFtime/issues}
}

}
\author{
\strong{Maintainer}: Patrick Van Laake \email{patrick@vanlaake.net} [copyright holder]

}
\keyword{internal}
