% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_clv_fitted.R, R/f_s3generics_clvfitted.R
\docType{class}
\name{clv.fitted-class}
\alias{clv.fitted-class}
\alias{show,clv.fitted-method}
\title{Fitted model without covariates}
\usage{
\S4method{show}{clv.fitted}(object)
}
\description{
The class stores the transaction data and various optimization outputs and options.
It is created already when model fitting is initiated and is then used to perform no covariate specific steps
during the estimation process.
Serves as parent classes to fitted transaction and spending models.

Created with an existing clv.data and clv.model object (or subclasses thereof).
}
\section{Slots}{

\describe{
\item{\code{call}}{Single language of the call used to create the object}

\item{\code{clv.model}}{Single object of (sub-) class \code{clv.model} that determines model-specific behavior.}

\item{\code{clv.data}}{Single object of (sub-) class \code{clv.data} that contains the data and temporal information to fit the model to.}

\item{\code{model.specification.args}}{Model specification given by the user with which the model was fit. Used to re-fit the model on new data (bootstrapping).}

\item{\code{prediction.params.model}}{Numeric vector of the model parameters, set and used solely when predicting. Named after model parameters in original scale and derived from \code{coef()}.}

\item{\code{optimx.estimation.output}}{A single object of class \code{optimx} as returned from method \code{optimx::optimx} after optimizing the log-likelihood fitting the model.}

\item{\code{optimx.hessian}}{Single matrix that is the hessian extracted from the last row of the optimization output stored in the slot \code{optimx.estimation.output}.}
}}

\seealso{
\linkS4class{clv.fitted.spending}, \linkS4class{clv.fitted.transactions}, \linkS4class{clv.fitted.transactions.static.cov}, \linkS4class{clv.fitted.transactions.dynamic.cov}
}
\keyword{internal}
