% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_flow_raster_trend.R
\name{ch_flow_raster_trend}
\alias{ch_flow_raster_trend}
\title{Raster plot and simple trends of observed streamflows by periods}
\usage{
ch_flow_raster_trend(
  DF,
  step = 5,
  missing = FALSE,
  metadata = NULL,
  colours = c("lightblue", "cyan", "blue", "slateblue", "darkblue", "red")
)
}
\arguments{
\item{DF}{- dataframe of daily flow data as read by ch_read_ECDE_flows}

\item{step}{- a number indicating the degree of smoothing eg. 1, 5, 11.}

\item{missing}{If \code{FALSE} years with missing data are excluded. 
If \code{TRUE} partial years are included.}

\item{metadata}{a dataframe of station metadata, default is HYDAT_list.}

\item{colours}{A vector of colours used for the raster plot. 
The default is \code{c("lightblue","cyan", "blue", "slateblue", 
"darkblue", "red")}.}
}
\value{
Returns a list containing:
  \item{stationID}{Station ID eg. 05BB001}
  \item{missing}{How missing values were used FALSE = used, TRUE = removed}
  \item{step}{number of days in a bin}
  \item{periods}{number of periods in a year}
  \item{period}{period numbers i.e. 1:365/step}
  \item{bins}{values for each period in each year}
  \item{med_period}{median for each period}
  \item{max_period}{maximum for each period}
  \item{min_period}{minimum for each period}
  \item{tau_period}{Kendalls Tau for each period}
  \item{prob_period}{probability of Tau for each period}
  \item{year}{years spanning the data}
  \item{median_year}{median bin for each year}
  \item{max_year}{maximum bin for each year}
  \item{min_year}{minimum bin for each year}
  \item{tau_median_year}{value of tau and probability for annual median}
  \item{tau_maximum_year}{value of tau and probability for annual maximum}
  \item{tau_minimum_year}{value of tau and probability for annual minimum}
}
\description{
Creates a raster plot plus trend plots for day of year, 
which are binned by a number of days (step),
and the max, min, and median annual discharge across years. The plot contains four panels based upon binned data.
}
\details{
The four plots are: (1) The maximum,minimum,and median flow with a trend test for each 
period: red arrows indicate decreases, blue arrows indicate increases.
(2) The scale bar for the colours used in the raster plot,
(3) The raster plot with a colour for each period and each year where data exist, and
(4) A time series plot of the minimum, median, and maximum annual bin values.
If there is no trend (p > 0.05) the points are black. Decreasing trends are in red, increasing trends are in blue.
}
\examples{
 data(CAN05AA008)
 mplot <- ch_flow_raster_trend(CAN05AA008, step=5)

}
\references{
Whitfield, P. H., Kraaijenbrink, P. D. A., Shook, K. R., and Pomeroy, J. W. 2021.
 The Spatial Extent of Hydrological and Landscape Changes across the Mountains and Prairies 
 of Canada in the Mackenzie and Nelson River Basins Based on data from a Warm Season Time Window, 
 Hydrology and Earth Systems Sciences 25: 2513-2541.
}
\seealso{
\code{\link{ch_flow_raster}}
}
\author{
Paul Whitfield
}
\keyword{plot}
