% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_sh_get_amax.R
\name{ch_sh_get_amax}
\alias{ch_sh_get_amax}
\title{Extracts annual maximum values from ECDE dataframe.}
\usage{
ch_sh_get_amax(df)
}
\arguments{
\item{df}{A dataframe of daily streamflow data from ECDE}
}
\value{
Returns a dataframe with the following variables  
 \item{year}{}
 \item{annual maximum}{}
 \item{date of annual maximum}{}
 \item{day of year of annual maximum}{}
 \item{days}{number of days with observations}
}
\description{
Extracts annual maximum values, the date of occurrence, the day of year, and the completeness 
from ECDE dataframe. Uses functions from timeDate ( \code{as.timeDate}, \code{dayOfYear}).
}
\examples{
data(CAN05AA008)
amax <- ch_sh_get_amax(CAN05AA008)
str(amax)
}
\seealso{
\code{\link{ch_read_ECDE_flows}}  \code{\link{ch_circ_mean_reg}}
}
\author{
Paul Whitfield
}
