% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_wbt_channels.R
\name{ch_wbt_channels}
\alias{ch_wbt_channels}
\title{Generate stream network}
\usage{
ch_wbt_channels(
  fn_flowacc,
  fn_flowdir,
  fn_channel_ras,
  fn_channel_vec,
  threshold = NULL,
  ...
)
}
\arguments{
\item{fn_flowacc}{File name for flow accumulation grid.}

\item{fn_flowdir}{File name for flow direction grid.}

\item{fn_channel_ras}{File name for raster version of channel network.}

\item{fn_channel_vec}{File name for vector version of channel networks.}

\item{threshold}{Threshold for channel initiation.}

\item{...}{Other parameters for \pkg{whitebox} function \code{wbt_extract_streams}}
}
\value{
Returns a \pkg{sf} vector object of the stream channels.
}
\description{
Generate stream network
}
\examples{
# Only proceed if Whitebox executable is installed
library(whitebox)
if (check_whitebox_binary()){
  library(raster)
  test_raster <- ch_volcano_raster()
  dem_raster_file <- tempfile(fileext = c(".tif"))
  no_sink_raster_file <- tempfile("no_sinks", fileext = c(".tif"))

  # write test raster to file
  writeRaster(test_raster, dem_raster_file, format = "GTiff")

  # remove sinks
  removed_sinks <- ch_wbt_removesinks(dem_raster_file, no_sink_raster_file, method = "fill")

  # get flow accumulations
  flow_acc_file <- tempfile("flow_acc", fileext = c(".tif"))
  flow_acc <- ch_wbt_flow_accumulation(no_sink_raster_file, flow_acc_file)

  # get flow directions
  flow_dir_file <- tempfile("flow_dir", fileext = c(".tif"))
  flow_dir <- ch_wbt_flow_direction(no_sink_raster_file, flow_dir_file)
  channel_raster_file <- tempfile("channels", fileext = c(".tif"))
  channel_vector_file <- tempfile("channels", fileext = c(".shp"))
  channels <- ch_wbt_channels(flow_acc_file, flow_dir_file, channel_raster_file,
  channel_vector_file, 1)
  plot(channels)
} else {
  message("Examples not run as Whitebox executable not found")
}
}
\author{
Dan Moore
}
