% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_model.r
\name{residualError}
\alias{residualError}
\title{Assign residual error model to model object}
\usage{
residualError(
  .Object,
  predName = "C",
  errorType = NULL,
  SD = NULL,
  isFrozen = FALSE,
  isBQL = FALSE,
  staticLLOQ = NULL,
  EObsBQL = NULL,
  CObsBQL = NULL,
  C1ObsBQL = NULL,
  A0ObsBQL = NULL,
  exponent = NULL
)
}
\arguments{
\item{.Object}{Model object}

\item{predName}{Name of the predicted variable as returned in \code{\link{residualEffectNames}}.}

\item{errorType}{Options are \code{"Additive"}, \code{"LogAdditive"}, \code{"Multiplicative"}, \code{"AdditiveMultiplicative"}, \code{"MixRatio"}, \code{"Power"}.}

\item{SD}{Value for the standard deviation of the residual error variable.}

\item{isFrozen}{Set to \code{TRUE} to freeze the standard deviation to the value specified for \code{SD}.}

\item{isBQL}{Set to \code{TRUE} if BQL values present in the observation data.}

\item{staticLLOQ}{Optional LLOQ value if \code{isBQL = TRUE}}

\item{EObsBQL}{Column mapping argument that represents the input dataset column that contains the BQL flag for observation values corresponding to \code{EObs}. Only applicable to \code{isBQL = TRUE}.}

\item{CObsBQL}{Column mapping argument that represents the input dataset column that contains the BQL flag for observation values corresponding to \code{CObs}. Only applicable to \code{isBQL = TRUE}.}

\item{C1ObsBQL}{Column mapping argument that represents the input dataset column that contains the BQL flag for observation values corresponding to \code{C1Obs}. Only applicable to \code{isBQL = TRUE}.}

\item{A0ObsBQL}{Column mapping argument that represents the input dataset column that contains the BQL flag for observation values corresponding to \code{AObs}. Only applicable to \code{isBQL = TRUE}.}

\item{exponent}{Value of exponent. Only applicable to \code{errorType = "Power"}.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Use to change or update residual error model for model object
}
\examples{
model <- pkindirectmodel(indirectType = "LimitedInhibition", isBuildup = FALSE,
 data = pkpdData, ID = "ID", Time = "Time", A1 = "Dose", CObs = "CObs", EObs = "EObs")

residualEffectNames(model)

# Change error type to "Multiplicative" and value of SD to 0.1 for "E"
model <- residualError(model, predName = "E", errorType = "Multiplicative", SD = 0.1)

# Change error type to "Power", value of SD to 0.15, and set exponent = 2 for "C"
model <- residualError(model, predName = "C", errorType = "Power", SD = 0.15, exponent = 2)

}
