% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chile_utm.R
\name{get_chile_utm}
\alias{get_chile_utm}
\title{Get Monthly Tax Unit (UTM) from the findic.cl API}
\usage{
get_chile_utm()
}
\value{
A tibble (data frame) with the following columns:
\itemize{
  \item \code{fecha}: Fecha de referencia del valor mensual (in format "YYYY-MM-DD").
  \item \code{valor}: Valor mensual de la Unidad Tributaria Mensual (UTM) en pesos chilenos (numeric).
}
}
\description{
This function retrieves the historical values of the Unidad Tributaria Mensual (UTM)
in Chilean Pesos from the API endpoint: \url{https://findic.cl/api/utm}.
The data is provided by the Chilean website \href{https://findic.cl}{findic.cl}.
}
\details{
The values returned by the API include metadata and a time series of monthly values.
The names of the variables and the values are in Spanish, exactly as provided by the API.
For example, the result includes columns named \code{fecha} (date) and \code{valor} (value).


The function sends a GET request to the \code{/api/utm} endpoint. If the request is successful (HTTP 200),
it parses the JSON response and extracts the time series data under the key \code{serie}.

All names and values are kept in Spanish as provided by the API and no translation or modification is applied.
}
\note{
Requires internet connection. The function returns the values exactly as provided in Spanish.
}
\examples{
\dontrun{
utm_data <- get_chile_utm()
head(utm_data)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
