% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcs.r
\name{stcfclayton}
\alias{stcfclayton}
\title{Clayton SpatioTemporal Correlation Structure}
\usage{
stcfclayton(t, s, scfid, tcfid, copulaarg, scfarg, tcfarg)
}
\arguments{
\item{t}{time lag}

\item{s}{spatial lag (distance)}

\item{scfid}{ID of the spatial (marginal) correlation structure (e.g. weibull)}

\item{tcfid}{ID of the temporal (marginal) correlation structure (e.g. weibull)}

\item{copulaarg}{parameter of the Clayton copula linking the marginal correlation structures}

\item{scfarg}{parameters of spatial (marginal) correlation structure}

\item{tcfarg}{parameters of temporal (marginal) correlation structure}
}
\description{
Provides spatiotemporal correlation structure function based on Clayton copula.
For more details on the parametric spatiotemporal correlation structures
see section 2.3 and 2.4 in Papalexiou and Serinaldi (2020).
}
\examples{

library(plot3D)

## specify grid of spatial and temporal lags
d <- 31
st <- expand.grid(0:(d - 1),
                  0:(d - 1))

## get the STCS
wc <- stcfclayton(t = st[, 1],
                  s = st[, 2],
                  scfid = 'weibull',
                  tcfid = 'weibull',
                  copulaarg = 2,
                  scfarg = list(scale = 20,
                                shape = 0.7),
                  tcfarg = list(scale = 1.1,
                                shape = 0.8))

## visualize the STCS
wc.m <- matrix(wc,
               nrow = d)

persp3D(z = wc.m, x = 1: nrow(wc.m), y = 1:ncol(wc.m),
        expand = 1, main = "", scale = TRUE, facets = TRUE,
        xlab="Time lag", ylab = "Distance", zlab = "STCF",
        colkey = list(side = 4, length = 0.5), phi = 20, theta = 120,
        resfac = 5,  col= gg2.col(100))

}
\references{
Papalexiou, S.M., Serinaldi, F. (2020). Random Fields Simplified:
Preserving Marginal Distributions, Correlations, and Intermittency,
With Applications From Rainfall to Humidity. Water Resources Research, 56(2),
e2019WR026331, \doi{10.1029/2019WR026331}

Papalexiou, S.M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond.
Water Resources Research, 57, e2020WR029466, \doi{10.1029/2020WR029466}
}
