% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TemplateImplementations.R
\name{createRxNormCohortTemplateDefinition}
\alias{createRxNormCohortTemplateDefinition}
\title{Create Rx Norm Cohort Template Definition}
\usage{
createRxNormCohortTemplateDefinition(
  connection,
  identifierExpression = "CAST(concept_id as bigint) * 1000",
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortDatabaseSchema,
  priorObservationPeriod = 365,
  nameSuffix = "",
  vocabularyDatabaseSchema = cdmDatabaseSchema
)
}
\arguments{
\item{connection}{Database connection object}

\item{identifierExpression}{An expression for setting the cohort id for the resulting cohort. Must produce unique ids}

\item{cdmDatabaseSchema}{CDM database schema}

\item{tempEmulationSchema}{Temporary emulation schema}

\item{cohortDatabaseSchema}{Cohort database schema}

\item{priorObservationPeriod}{(optional) Required prior observation period for individuals}

\item{nameSuffix}{A name suffix to use to add to the cohort names - this is useful if you're using multiple
parameterized versions of this definition}

\item{vocabularyDatabaseSchema}{Vocabulary database schema}
}
\value{
A CohortTemplateDefinition instance
}
\description{
Template cohort definition for all RxNorm ingredients. This cohort will use the
vocabulary tables to automatically generate a set of cohorts that have the
cohortId = conceptId * 1000. The "identifierExpression" can be customized for uniqueness.
}
