% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.ClassWeightedVoting.R
\name{ClassWeightedVoting}
\alias{ClassWeightedVoting}
\title{Implementation Weighted Voting scheme.}
\description{
A new implementation of \code{\link{ClassMajorityVoting}} where
each class value has different values (weights).
}
\seealso{
\code{\link{D2MCS}}, \code{\link{ClassMajorityVoting}},
\code{\link{ClassWeightedVoting}}, \code{\link{ProbAverageVoting}},
\code{\link{ProbAverageWeightedVoting}}, \code{\link{ProbBasedMethodology}}
}
\keyword{math}
\keyword{methods}
\keyword{models}
\section{Super class}{
\code{\link[D2MCS:SimpleVoting]{D2MCS::SimpleVoting}} -> \code{ClassWeightedVoting}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ClassWeightedVoting-new}{\code{ClassWeightedVoting$new()}}
\item \href{#method-ClassWeightedVoting-getWeights}{\code{ClassWeightedVoting$getWeights()}}
\item \href{#method-ClassWeightedVoting-setWeights}{\code{ClassWeightedVoting$setWeights()}}
\item \href{#method-ClassWeightedVoting-execute}{\code{ClassWeightedVoting$execute()}}
\item \href{#method-ClassWeightedVoting-clone}{\code{ClassWeightedVoting$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="SimpleVoting" data-id="getCutoff"><a href='../../D2MCS/html/SimpleVoting.html#method-SimpleVoting-getCutoff'><code>D2MCS::SimpleVoting$getCutoff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="SimpleVoting" data-id="getFinalPred"><a href='../../D2MCS/html/SimpleVoting.html#method-SimpleVoting-getFinalPred'><code>D2MCS::SimpleVoting$getFinalPred()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassWeightedVoting-new"></a>}}
\if{latex}{\out{\hypertarget{method-ClassWeightedVoting-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassWeightedVoting$new(cutoff = 0.5, weights = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{A \link{character} vector defining the minimum probability
used to perform a positive classification. If is not defined, 0.5 will be
used as default value.}

\item{\code{weights}}{A \link{numeric} vector with the weights of each cluster.
If \link{NULL} performance achieved during training will be used as
default.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassWeightedVoting-getWeights"></a>}}
\if{latex}{\out{\hypertarget{method-ClassWeightedVoting-getWeights}{}}}
\subsection{Method \code{getWeights()}}{
The function returns the weights used to perform the voting
scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassWeightedVoting$getWeights()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassWeightedVoting-setWeights"></a>}}
\if{latex}{\out{\hypertarget{method-ClassWeightedVoting-setWeights}{}}}
\subsection{Method \code{setWeights()}}{
The function allows changing the value of the weights.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassWeightedVoting$setWeights(weights)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{weights}}{A \link{numeric} vector containing the new weights.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassWeightedVoting-execute"></a>}}
\if{latex}{\out{\hypertarget{method-ClassWeightedVoting-execute}{}}}
\subsection{Method \code{execute()}}{
The function implements the cluster-weighted majority voting
procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassWeightedVoting$execute(predictions, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictions}}{A \code{\link{ClusterPredictions}} object containing
all the predictions achieved for each cluster.}

\item{\code{verbose}}{A \link{logical} value to specify if more verbosity is
needed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassWeightedVoting-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ClassWeightedVoting-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassWeightedVoting$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
