% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.ExecutedModels.R
\name{ExecutedModels}
\alias{ExecutedModels}
\title{Handles training of M.L. models}
\description{
Allows to manage the executed M.L. models.
}
\seealso{
\code{\link{Model}}
}
\keyword{error}
\keyword{internal}
\keyword{methods}
\keyword{misc}
\keyword{utilities}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExecutedModels-new}{\code{ExecutedModels$new()}}
\item \href{#method-ExecutedModels-getNames}{\code{ExecutedModels$getNames()}}
\item \href{#method-ExecutedModels-getBest}{\code{ExecutedModels$getBest()}}
\item \href{#method-ExecutedModels-add}{\code{ExecutedModels$add()}}
\item \href{#method-ExecutedModels-exist}{\code{ExecutedModels$exist()}}
\item \href{#method-ExecutedModels-size}{\code{ExecutedModels$size()}}
\item \href{#method-ExecutedModels-save}{\code{ExecutedModels$save()}}
\item \href{#method-ExecutedModels-delete}{\code{ExecutedModels$delete()}}
\item \href{#method-ExecutedModels-clone}{\code{ExecutedModels$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$new(dir.path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{The location were the executed models will be saved.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-getNames"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-getNames}{}}}
\subsection{Method \code{getNames()}}{
The function is used to obtain the name of the ML model
achieved the best performance during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$getNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of length 1 of \link{NULL}
if no ML model have been trained.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-getBest"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-getBest}{}}}
\subsection{Method \code{getBest()}}{
The function is responsible of returning the model achieving
the best performance value during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$getBest()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link{Model}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-add"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-add}{}}}
\subsection{Method \code{add()}}{
The function inserts a new model to the list of executed
models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$add(model, keep.best = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{A previously trained model (in \code{\link{Model}} object).}

\item{\code{keep.best}}{A \link{logical} value to define the saving operation.
If \link{TRUE} only saves the best model, otherwise all executed models
are saved.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-exist"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-exist}{}}}
\subsection{Method \code{exist()}}{
The function is used to discern if a specific model has been
executed previously.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$exist(model.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model.name}}{A \link{character} vector with the name of the
model to check for existence.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{logical} value. \link{TRUE} if the model exists
and \link{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-size"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-size}{}}}
\subsection{Method \code{size()}}{
The function is used to compute the number of executed ML
models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector or size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-save"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-save}{}}}
\subsection{Method \code{save()}}{
The function is responsible of saving the information of all
executed models into a hidden file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$save()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-delete"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-delete}{}}}
\subsection{Method \code{delete()}}{
The function removes an specific model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$delete(model.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model.name}}{A \link{character} vector with the name of the
model to be removed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecutedModels-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExecutedModels-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
