% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.Recall.R
\name{Recall}
\alias{Recall}
\title{Computes the Recall Value.}
\description{
Recall (also known as sensitivity) is the fraction of the total
amount of relevant instances that were actually retrieved.
}
\details{
\deqn{recall = TP / (TP + FN)}
}
\seealso{
\code{\link{MeasureFunction}}, \code{\link{ClassificationOutput}},
\code{\link{ConfMatrix}}
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:MeasureFunction]{D2MCS::MeasureFunction}} -> \code{Recall}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Recall-new}{\code{Recall$new()}}
\item \href{#method-Recall-compute}{\code{Recall$compute()}}
\item \href{#method-Recall-clone}{\code{Recall$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Recall-new"></a>}}
\if{latex}{\out{\hypertarget{method-Recall-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Recall$new(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used as basis to compute the measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Recall-compute"></a>}}
\if{latex}{\out{\hypertarget{method-Recall-compute}{}}}
\subsection{Method \code{compute()}}{
The function computes the \strong{Recall} achieved by the M.L.
model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Recall$compute(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used as basis to compute the \strong{Recall}
measure.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is automatically invoke by the
\code{\link{ClassificationOutput}} object.
}

\subsection{Returns}{
A \link{numeric} vector of size 1 or \link{NULL} if
an error occurred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Recall-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Recall-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Recall$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
