% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmgof.R
\name{cvmgof}
\alias{cvmgof}
\title{Perform the Cramer-von Mises Goodness-of-Fit Test for Normality}
\usage{
cvmgof(x)
}
\arguments{
\item{x}{A numeric vector containing the sample data.}
}
\value{
\item{statistic}{The value of the Cramer-von Mises test statistic.}
\item{p.value}{The p-value for the test.}
\item{method}{A character string describing the test.}
}
\description{
Perform the Cramer-von Mises Goodness-of-Fit Test for Normality
}
\examples{
# Example usage:
set.seed(123)
x <- rnorm(100)  # Generate a sample from a normal distribution
result <- cvmgof(x)
print(result)

# Example with non-normal data:
y <- rexp(100)  # Generate a sample from an exponential distribution
result <- cvmgof(y)
print(result)
}
