% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prognosis.R
\name{stacking_pro}
\alias{stacking_pro}
\title{Train Stacking Ensemble for Prognosis}
\usage{
stacking_pro(
  results_all_models,
  data,
  meta_model_name,
  top = 3,
  tune_meta = FALSE,
  time_unit = "day",
  years_to_evaluate = c(1, 3, 5),
  seed = 789
)
}
\arguments{
\item{results_all_models}{List of results from \code{models_pro()}.}

\item{data}{Training data.}

\item{meta_model_name}{Name of the meta-learner (e.g., "lasso_pro").}

\item{top}{Integer. Number of top base models to include based on C-index.}

\item{tune_meta}{Logical. Tune the meta-learner?}

\item{time_unit}{Time unit.}

\item{years_to_evaluate}{Evaluation years.}

\item{seed}{Integer seed.}
}
\value{
A list containing the stacking object and evaluation results.
}
\description{
Implements a Stacking Ensemble (Super Learner).
It uses the risk scores from top-performing base models as meta-features
to train a second-level meta-learner.
}
