% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enmtools.calibrate.R
\name{enmtools.calibrate}
\alias{enmtools.calibrate}
\title{Takes an emtools.model object, and reformats it to run through the CalibratR package, calculates Continuous Boyce Index, and runs a Hosmer-Lemeshow goodness-of-fit test.  Can either do a full CalibratR run or just return ECE/MCE statistics and plots.}
\usage{
enmtools.calibrate(
  model,
  recalibrate = FALSE,
  cuts = 11,
  env = NA,
  n.background = 10000,
  recal.methods = c(1, 2, 3, 4),
  ...
)
}
\arguments{
\item{model}{An enmtools.model object}

\item{recalibrate}{When TRUE, does a full CalibratR "calibrate" run to recalibrate the model.  When FALSE, just returns metrics and plots measuring calibration of the model as is.}

\item{cuts}{The number of bins to split suitability scores into for calculating calibration.}

\item{env}{A set of environment layers to be used for optional env space metrics}

\item{n.background}{Number of background points to be used for env space metrics}

\item{recal.methods}{Numeric or vector specifying which methods the CalibratR package should use for recalibration.   1=hist_scaled, 2=hist_transformed, 3=BBQ_scaled, 4=BBQ_transformed.  Option 5 is disabled by default due to errors.}

\item{...}{Further arguments to be passed to CalibratR's "calibrate" function.}
}
\value{
An enmtools.calibrate object containing calibration and classificaction plots, metrics of model calibration, and (optionally) versions of the model that were recalibrated using various methods.
}
\description{
Takes an emtools.model object, and reformats it to run through the CalibratR package, calculates Continuous Boyce Index, and runs a Hosmer-Lemeshow goodness-of-fit test.  Can either do a full CalibratR run or just return ECE/MCE statistics and plots.
}
\examples{
\donttest{
#install.extras(repos='http://cran.us.r-project.org')
monticola.glm <- enmtools.glm(iberolacerta.clade$species$monticola,
                              env = euro.worldclim,
                              f = pres ~ bio1 + bio9,
                              test.prop = 0.3)
if(check.extras("enmtools.calibrate")) {
  enmtools.calibrate(monticola.glm)
}
}
}
