% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distER.R
\name{distER}
\alias{distER}
\title{Simulating many sequential testing with evidence ratios and plotting their distribution}
\usage{
distER(cohensd, nmin, nmax, nsims, ic = bic)
}
\arguments{
\item{cohensd}{Expected effect size}

\item{nmin}{Minimum sample size from which start computing ERs}

\item{nmax}{Maximum sample size at which stop computing ERs}

\item{nsims}{Number of experiments to simulate.}

\item{ic}{Indicates whether to use the aic or the bic}
}
\description{
Simulating many sequential evidence ratios using \code{simER}, keeps the last
of each simulation, and plotting their distribution.
}
\examples{
\dontrun{distER(cohensd = 0.6, nmin = 20, nmax = 100, nsims = 100, ic = bic)}

}
\seealso{
\code{\link{simER}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
