% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotFragHeatmap}
\alias{plotFragHeatmap}
\alias{plotFragQuantile}
\alias{plotFragDistribution}
\title{Visualization functions (raw signal, fragility matrix)}
\usage{
plotFragHeatmap(frag, sozIndex = NULL)

plotFragQuantile(frag, sozIndex = NULL)

plotFragDistribution(frag, sozIndex = NULL)
}
\arguments{
\item{frag}{Fragility object from \code{calcAdjFrag}}

\item{sozIndex}{Integer or string. A group of electrodes to mark as in the Seizure Onset Zone (SOZ)}
}
\value{
A ggplot object
}
\description{
\code{plotFragHeatmap}: plot fragility heatmaps with electrodes marked as soz colored

\code{plotFragQuantile}: Plot Fragility time quantiles for two electrodes group marked as SOZ and reference

\code{plotFragQuantile}: Plot Fragility time distribution for two electrodes group marked as SOZ and reference
}
\examples{

data("pt01EcoG")

## sozIndex is the index of the electrodes we assume are in the SOZ
sozIndex <- attr(pt01EcoG, "sozIndex")

## precomputed fragility object
data("pt01Frag")

## plot the fragility heatmap
plotFragHeatmap(frag = pt01Frag, sozIndex = sozIndex)

## plot the fragility quantiles
plotFragQuantile(frag = pt01Frag, sozIndex = sozIndex)

## plot the fragility distribution
plotFragDistribution(frag = pt01Frag, sozIndex = sozIndex)

}
