% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{plotFA}
\alias{plotFA}
\title{Plot FA EICs}
\usage{
plotFA(msbatch, dmz, verbose = TRUE)
}
\arguments{
\item{msbatch}{annotated msbatch.}

\item{dmz}{mz tolerance in ppm for EIC extraction.}

\item{verbose}{print information messages.}
}
\value{
annotated msbatch with saved plots.
}
\description{
Plot FA EICs
}
\examples{
\dontrun{
msbatch <- annotateFA(msbatch, dmz = 5)

plots <- plotFA(msbatch, dmz = 10)

pdf("FAs.pdf")
for (p in 1:length(plots)){
  print(plots[[p]])
}
dev.off()
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
