% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link2tidymodels.R
\name{fit_krr}
\alias{fit_krr}
\alias{fit_krr.default}
\alias{fit_krr.formula}
\title{Fit Kernel Ridge Regression}
\usage{
fit_krr(x, ...)

\method{fit_krr}{default}(x, y, ...)

\method{fit_krr}{formula}(x, data, intercept = FALSE, ...)
}
\arguments{
\item{x}{For the base method, a numeric design matrix \eqn{X \in \mathbb{R}^{n \times d}}.
For the formula method, a model formula.}

\item{...}{Additional arguments passed to the underlying engine
(e.g., \code{"kernel"}, \code{"rho"}, \code{"penalty"}, \code{"opt"},
 \code{"m"}, \code{"fastcv"}, etc.).}

\item{y}{Response vector \eqn{y \in \mathbb{R}^n}.}

\item{data}{A data frame (formula method).}

\item{intercept}{If \code{FALSE}, the formula method removes the
intercept term by updating the terms to \code{.~.-1}. Default: \code{FALSE}.}
}
\value{
A fitted KRR object (class includes \code{"krr"}).
}
\description{
`fit_krr()` fits Kernel Ridge Regression (KRR) either from a
design matrix (\code{x}) with a response (\code{y}), or via a formula interface.
The function is designed to be used with the tidymodels stack.
In particular, this package provides a \pkg{parsnip} model specification
\code{krr_reg()} with the engine \code{"fastkrr"}, so you can fit KRR inside
\pkg{recipes}/\pkg{workflows} pipelines just like any other tidymodels model.
}
\section{Tidymodels integration}{

\itemize{
\item Use \code{krr_reg(mode = "regression", ...) \%>\% parsnip::set_engine("fastkrr")}
  to select the FastKRR engine.
\item Combine with \pkg{recipes} and \pkg{workflows} to build modular pipelines for
  preprocessing, resampling, and evaluation.
}
}

\examples{
\donttest{
if (all(vapply(
  c("parsnip","stats","modeldata"),
  requireNamespace, quietly = TRUE, FUN.VALUE = logical(1)
))) {
library(modeldata)
library(dplyr)

# Example : matrix interface
# Data analysis
data(ames)
ames = ames \%>\% mutate(Sale_Price = log10(Sale_Price))

set.seed(502)
x = as.matrix(ames[, c("Longitude", "Latitude")])
y = ames[, "Sale_Price", drop = TRUE]

fit1 = fit_krr(
  x, y,
  kernel = "gaussian",
  opt    = "exact",
  rho    = 1,
  lambda = 1e-4
)

# Example : formula interface
fit2 = fit_krr(
  Sale_Price ~ .,
  data   = ames,
  kernel = "gaussian",
  opt    = "exact",
  rho    = 1,
  lambda = 1e-4
)
}}

}
\seealso{
\code{\link{krr_reg}}, \pkg{parsnip}, \pkg{workflows},
  \pkg{recipes}, \pkg{tidymodels}
}
