% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_gtfs.R
\name{explore_gtfs}
\alias{explore_gtfs}
\title{Explore GTFS Data in an Interactive Shiny Application}
\usage{
explore_gtfs(gtfs)
}
\arguments{
\item{gtfs}{A GTFS object, preferably of class `wizardgtfs`. If not, the function attempts to convert it
to `wizardgtfs` using `GTFSwizard::as_wizardgtfs()`.}
}
\value{
A Shiny app object that, when run, opens an interactive dashboard for GTFS data exploration.
}
\description{
This function pops-up a Shiny application for exploring General Transit Feed Specification (GTFS) data.
The application provides an overview of the GTFS data, visualizations of route characteristics, and
detailed information on selected routes, allowing users to analyze various aspects of a GTFS feed interactively.
}
\details{
The Shiny application generated by this function has two main tabs:
- **Overview**: Displays general GTFS information, maps, and summary charts of the transit system, including frequency, fleet, speed, and other statistics.
- **By Route**: Allows users to select specific routes and view detailed maps and visualizations for each selected route.

If the provided `gtfs` object does not contain a `shapes` table, it will attempt to add it using `GTFSwizard::get_shapes()`, issuing a warning
}
\examples{
if (interactive()) {
  # To run the Shiny application:
  explore_gtfs(gtfs = GTFSwizard::for_rail_gtfs)
}

}
\seealso{
[GTFSwizard::as_wizardgtfs()], [GTFSwizard::get_shapes()], [GTFSwizard::plot_calendar()]
}
