% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_trip.R
\name{split_trip}
\alias{split_trip}
\title{Split a Trip into Sub-Trips within a GTFS Object}
\usage{
split_trip(gtfs, trip, split = 1)
}
\arguments{
\item{gtfs}{A GTFS object, ideally of class `wizardgtfs`. If not, it will be converted.}

\item{trip}{A character vector specifying the `trip_id` to be split.}

\item{split}{An integer indicating the number of splits to apply. One split means two trip segments.}
}
\value{
A GTFS object with the specified trip split into new sub-trips.
}
\description{
`split_trip` divides a specified trip in a `wizardgtfs` object into multiple sub-trips by updating the stop sequences, trip identifiers, and related data, allowing for analysis or adjustments to different segments of the original trip.
}
\details{
- The function creates sub-trips by dividing the specified trip(s) into equal parts based on the stop sequence.

- New trip IDs are generated for each sub-trip, and `stop_times`, `trips`, `frequencies`, and `transfers` tables are updated accordingly.

- If `shape_dist_traveled` is present, it is adjusted to reflect distances within each new sub-trip.

- After the split, the function re-generates the shapes table for the new trips using `get_shapes`, and merges it back into the `wizardgtfs` object.

- Be aware: `get_shapes` reconstructs shapes using euclidean approximation and may not be accurate.

- The maximum number of sections in a given trip is restricted by its amount of stops
}
\note{
`split_trip()` uses stop sequences to recriate the shapes table of split trips; accordingly, it should not be used after `filter_time()`, as this function removes invalid `stop_times`.
}
\examples{
# Split a trip into 3 segments
gtfs_split <- split_trip(for_rail_gtfs, trip = for_rail_gtfs$trips$trip_id[1:3], split = 2)

}
\seealso{
[GTFSwizard::get_shapes()], [GTFSwizard::merge_gtfs()]
}
