% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFuncLib.R
\name{Run_KMT}
\alias{Run_KMT}
\title{Implementing Khmaladze Martingale Transformation.}
\usage{
Run_KMT(
  X,
  strDistr = "Normal",
  bEstimation = FALSE,
  bFast_Estimation = FALSE,
  bParallel = FALSE,
  nThreads = 16
)
}
\arguments{
\item{X}{a random sample of n observations}

\item{strDistr}{a null distribution for the hypothesis test: Normal, Cauchy, Logistic, or Gumbel.}

\item{bEstimation}{a logical value which specifies whether or not to estimate parameters. The default value is TRUE. For FALSE, (\eqn{\mu}) and (\eqn{\sigma}) will be set as 0 and 1, respectively.}

\item{bFast_Estimation}{a logical value which specifies whether or not to use the maximum likelihood estimator (\eqn{\hat{\theta}}) for the location and scale parameters The default value is FALSE.}

\item{bParallel}{a logical value which specifies whether or not to use the parallel computing. The default value is FALSE.}

\item{nThreads}{the number of threads when bParallel is TRUE. The default value is 16.}
}
\value{
A list of the following values:
\describe{
\item{opt_x}{ opt.x is the value of x where the optimum of the objective function - which is also the test statistic - occurs.}

\item{test_stat}{ test.stat is the test statistic obtained through Khmaladze martingale transformation.}

\item{mu}{ the point estimate for the location parameter mu}

\item{sigma}{ the point estimate for the scale parameter sigma}
}
}
\description{
Performs goodness-of-fit test through Khmaladze matringale transformation
}
\examples{
####################
n=20
mu0=2; sigma0=1
X = rnorm(n, mu0, sigma0)


Run_KMT(X, strDistr="Normal")

}
\references{
[1] Khmaladze, E.V., Koul, H.L. (2004). Martingale transforms goodness-of-fit tests in regression models. Ann. Statist., 32. 995-1034

[2] E.V. Khmaladze, H.L. Koul (2009). Goodness-of-fit problem for errors in nonparametric regression: distribution free approach. Ann. Statist., 37(6A) 3165-3185.

[3] Kim, Jiwoong (2020). Implementation of a goodness-of-fit test through Khmaladze martingale transformation. Comp. Stat., 35(4): 1993-2017
}
