% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildGazeteer.R
\name{buildGazeteer}
\alias{buildGazeteer}
\title{Define Categories of Genes Supported by the IPD-IMGT/HLA Database}
\source{
Andersson G. Evolution of the human HLA-DR region. Front. Biosci. 1998 Jul 27:3:d739-45.

Alexandrov et al. HLA-OLI: A new MHC class I pseudogene and HLA-Y are located on a 60 kb indel in the human MHC between HLA-W and HLA-J. HLA 2023 Nov; 102(5):599-606.
}
\usage{
buildGazeteer(version = getLatestVersion())
}
\arguments{
\item{version}{A string identifying of the desired IPD-IMGT/HLA Database release version to which the gazeteer should be updated. The default value is most recent IPD-IMGT/HLA Database release version.}
}
\value{
A list object of vectors organizing the genes in the IPD-IMGT/HLA Database into specific categories.
}
\description{
Consumes information in the ANHIG/IMGTHLA GitHub repository and at hla.alleles.org/genes to define specific categories of genes supported by the IPD-IMGT/HLA Database, which are represented as nineteen elements of the HLAgazeteer object.

Elements:
\itemize{
\item All genes with alignments ($align)
\item Genes that that do and do not have amino acid ($prot/$noprot), nucleotide ($nuc/$nonuc), and genomic ($gen/$nogen) alignments
\item HLA genes ($hla), pseudogenes ($pseudo), gene fragments ($frag)
\item Genes that are expressed ($expressed) or not expressed ($notexpressed)
\item Genes in the Class I region ($classireg), Class I HLA genes ($classIhla), Genes in the Class II region ($classiireg), and Class II HLA genes ($classiihla)
\item Classical HLA genes ($classical) and non-classical exprssed HLA genes ($nonclassical)
\item All genes presented in map order ($map)
}

The twentieth element ($version) identifies the IPD-IMGT/HLA Database version used to build the HLAgazeteer.
}
\note{
The \emph{$prot} and \emph{$nuc} vectors include a 'DRB' "gene". While 'DRB' is not a gene name, the DRB_prot.txt file includes combined alignments for the DRB1, DRB3, DRB4, and DRB5 genes, and the DRB_nuc.txt file includes combined alignments for the DRB1, DRB2, DRB3, DRB4, DRB5, DRB6, DRB7, DRB8, and DRB9 genes. 'DRB' is included in these vectors for the purpose of validation when these combined alignments are desired.

For interal HLAtools use.

These elements are constructed using data compiled from hla.alleles.org/genes/, github.com/ANHIG/IMGTHLA/tree/Latest/alignments, DOI:10.2741/a317, DOI:10.1111/tan.15180, and Human Genome Assembly GRCh38.p14 reference assembly NC_000006.12.

Additional information about these genes can be found in HLAtools::IMGTHLAGeneTypes.

The $map element does not distinguish the order of the DRB3, DRB4 and DRB5 genes (DRB3/4/5) or the DR6 and DR7 (DR6/7) genes, as the individual elements of these gene sets are found on different DRB haplotypes.

This function requires internet access to function.
}
