% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_ExtractStats.R
\name{ExtractStats}
\alias{ExtractStats}
\title{Extract statistics from time series}
\usage{
ExtractStats(
  x,
  start.mon = 1,
  aggperiod = c("year", "season1", "season2", "month"),
  timestep = attr(x, "timestep"),
  subid = attr(x, "subid"),
  FUN,
  ...
)
}
\arguments{
\item{x}{Data frame, with column-wise equally-spaced time series. Date-times in \code{\link{POSIXct}} format in first column.
Typically an imported time output file from HYPE.}

\item{start.mon}{Integer between 1 and 12, starting month of the hydrological year.}

\item{aggperiod}{Character string, timestep for aggregated results. One of \code{"year"} for annual statistics,
\code{"season1"} (winter/summer half-years), \code{"season2"} (4 seasons), or \code{"month"}. See details.}

\item{timestep}{Character string, timestep of data in \code{x}. Attribute \code{timestep} in \code{x} per default.
Otherwise one of \code{"month"} (not allowed with \code{aggperiod = "month"}), \code{"week"}, \code{"day"}, or
\code{"nhour"} (n = number of hours).}

\item{subid}{Integer, a vector of HYPE subbasin IDs for data in \code{x}. Attribute \code{subid} in \code{x} per default.}

\item{FUN}{A function to compute for each \code{aggperiod} in \code{x}.}

\item{...}{Optional arguments to \code{FUN}.}
}
\value{
\code{ExtractStats} returns a dataframe with starting dates for each aggregation period in the first column, and a descriptive
aggregation period name in the second. Remaining columns contain aggregated results as ordered in \code{x}. Additional attributes
\code{subid} with subbasin IDs, \code{timestep} with time step of the source data, and \code{period} with a two-element POSIXct vector
containing start and end dates of the source data.
}
\description{
Calculate aggregated statistics from long-term time series, typically imported HYPE time output files.
}
\details{
\code{ExtractStats} uses \code{\link{aggregate}} to calculate statistics for all data columns provided in \code{x}. Argument
\code{start.mon} allows to define the start of the hydrological year. Hydrological seasons begin with winter (season1) or
autumn (season2).
}
\note{
If \code{FUN} returns several values per aggregation period, these are returned in nested columns in the resulting dataframe. See
\code{Value} section for \code{\link{aggregate}} and example code below.
}
\examples{
# Import example data
te1 <- ReadTimeOutput(filename = system.file("demo_model", "results",
"timeCOUT.txt", package = "HYPEtools"), dt.format = "\%Y-\%m")
# Extract maxima
ExtractStats(x = te1, start.mon = 1, FUN = max)
# Multiple result stats: Extract min, mean, and max in one go:
te2 <- ExtractStats(x = te1, start.mon = 1,
FUN = function(x) {c(min(x), mean(x), max(x))})
# extract mean from resulting nested dataframe:
data.frame(te2[, 1:2], sapply(te2[, -c(1:2)], function(x){x[, 2]}))

}
