% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_HypeSingleVar.R
\name{HypeSingleVar}
\alias{HypeSingleVar}
\title{HypeSingleVar arrays}
\usage{
HypeSingleVar(x, datetime, subid = NULL, outregid = NULL, hype.var)
}
\arguments{
\item{x}{numeric \code{\link{array}} with three dimensions, which holds HYPE results for one variable as (in order)
\code{[datetime, subid/outregid, iteration]}.}

\item{datetime}{\code{\link{POSIXct}} date-time vector of the same length as \code{time} dimension of \code{x}
with equidistant time steps (starting day for time steps from weekly to annual), or character string for full model
period averages, e.g. \code{"2000-2010"}.}

\item{subid}{Integer vector with HYPE sub-basin IDs, of the same length as \code{subid} dimension of \code{x}. Either this
or \code{outregid} must be supplied.}

\item{outregid}{Integer vector with HYPE output region IDs, alternative to \code{subid}.}

\item{hype.var}{Character string, keyword to specify HYPE variable ID, see
\href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:info.txt:variables}{list of HYPE variable}.
Not case-sensitive.}
}
\value{
Returns a 3-dimensional array with
\code{[time, subid, iteration]} dimensions and additional \code{\link{attributes}}:
\describe{
\item{\strong{datetime}}{A vector of date-times. Corresponds to 1st array dimension.}
\item{\strong{subid}}{A vector of SUBIDs. Corresponds to 2nd array dimension (\code{NA}, if it does not apply to data contents).}
\item{\strong{outregid}}{A vector of OUTREGIDs. Corresponds to 2nd array dimension (\code{NA}, if it does not apply to data contents).}
\item{\strong{variable}}{HYPE output variable ID.}
\item{\strong{timestep}}{A character keyword for the time step.}
}
}
\description{
Constructor function for arrays which hold equidistant time series of a single HYPE variable for multiple sub-basins
and multiple model runs, typically imported time and map output results.
}
\details{
S3 class constructor function for array objects which can hold (multiple) HYPE time or map output results.
}
\examples{
# Import a time output file
te1 <- ReadTimeOutput(filename = system.file("demo_model", "results",
"timeCOUT.txt", package = "HYPEtools"), dt.format = "\%Y-\%m")
# Create a dummy array with two iterations from imported time file
te2 <- array(data = c(unlist(te1[, -1]),  unlist(te1[, -1])), 
             dim = c(nrow(te1), ncol(te1) - 1, 2), 
             dimnames = list(rownames(te1), colnames(te1)[-1]))
# Construct HypeSingleVar array
HypeSingleVar(x = te2, datetime = te1$DATE,
subid = subid(te1), hype.var = variable(te1))

}
