% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp.norm.test.R
\name{comp_norm_test}
\alias{comp_norm_test}
\title{Selection of Nonnormal Invariant Components Using Marginal Normality Tests}
\usage{
comp_norm_test(
  object,
  test = "agostino.test",
  type = "smallprop",
  level = 0.05,
  adjust = TRUE
)
}
\arguments{
\item{object}{object of class \code{"ICS"} where both \code{S1} and \code{S2} are specified as functions.
The sample size and the dimension of interest are also obtained from the object.}

\item{test}{name of the normality test to be used. Possibilites are \code{"jarque.test"},
\code{"anscombe.test"}, \code{"bonett.test"}, \code{"agostino.test"}, \code{"shapiro.test"}.
Default is \code{"agostino.test"}.}

\item{type}{currently the only option is \code{"smallprop"}. See details.}

\item{level}{the initial level used to make a decision based on the test p-values. See details.}

\item{adjust}{logical. If \code{TRUE}, the quantiles levels are adjusted. Default is \code{TRUE}. See details.}
}
\value{
A list containing:
\itemize{
\item \code{index}:  integer vector indicating the indices of the selected components.
\item \code{test}: string with the name of the normality test used.
\item \code{criterion}: vector of the p-values from the marginal normality tests for each component.
\item \code{levels}: vector of the levels used for the decision for each component.
\item \code{adjust}: logical. \code{TRUE} if adjusted.
\item \code{type}: \code{type} used
}
}
\description{
Identifies invariant coordinates that are non normal using univariate normality tests.
}
\details{
Currently the only available \code{type} is \code{"smallprop"} which detects which of the components follow a univariately normal distribution. It starts from the first component and stops when a component is detected as gaussian. Five tests for univariate normality are available. See \link[ICSClust:normal_crit]{normal_crit()} function for more general cases.

If \code{adjust = FALSE} all tests are performed at the same \code{level}. This leads however often to too many components. Therefore some multiple testing adjustments might be useful. The current default adjusts the level for the jth component as \code{level}/j.

Note that the function is seldomly called directly by the user but internally by \code{\link[=ICS_outlier]{ICS_outlier()}}.
}
\examples{

Z <- rmvnorm(1000, rep(0, 6))
# Add 20 outliers on the first component
Z[1:20, 1] <- Z[1:20, 1] + 10
pairs(Z)
icsZ <- ICS(Z)
# The shift located outliers can be displayed in one dimension
comp_norm_test(icsZ)
# Only one invariant component is non normal and selected.
comp_norm_test(icsZ, test = "bonett.test")

# Example with no outlier
Z0 <- rmvnorm(1000, rep(0, 6))
pairs(Z0)
icsZ0 <-ICS(Z0)
# Should select no component
comp_norm_test(icsZ0, level = 0.01)$index

}
\references{
Archimbaud, A., Nordhausen, K. and Ruiz-Gazen, A. (2018), ICS for multivariate outlier detection with application to quality control. Computational Statistics & Data Analysis, 128:184-199. ISSN 0167-9473.  \doi{10.1016/j.csda.2018.06.011}.
}
\seealso{
\link[ICS:ICS-S3]{ICS()}, \code{\link[=comp_simu_test]{comp_simu_test()}}, \link[moments:jarque.test]{jarque.test()},
\link[moments:anscombe.test]{anscombe.test()}, \link[moments:bonett.test]{bonett.test()}, \link[moments:agostino.test]{bonett.test()},
\link[stats:shapiro.test]{shapiro.test()}
}
\author{
Aurore Archimbaud and Klaus Nordhausen
}
