% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{modelCompare}
\alias{modelCompare}
\alias{as.modelCompare}
\alias{is.modelCompare}
\alias{modelCompare.lm}
\title{Compare Two Models}
\usage{
modelCompare(model1, model2, ...)

as.modelCompare(x)

is.modelCompare(x)

\method{modelCompare}{lm}(model1, model2, ...)
}
\arguments{
\item{model1}{A fitted model object.}

\item{model2}{A fitted model object to compare to \code{model1}}

\item{...}{Additional arguments passed to specific methods.}

\item{x}{An object (e.g., list or a modelCompare object) to
test or attempt coercing to a modelCompare object.}
}
\value{
Depends on the method dispatch.
}
\description{
Generic function.
}
\examples{
m1 <- lm(mpg ~ qsec * hp, data = mtcars)

m2 <- lm(mpg ~ am, data = mtcars)

modelCompare(m1, m2)

## cleanup
rm(m1, m2)

\dontrun{
m3 <- lm(mpg ~ 1, data = mtcars)
m4 <- lm(mpg ~ 0, data = mtcars)
modelCompare(m3, m4)

## cleanup
rm(m3, m4)
}
}
