% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MdeFunc31.R
\name{KoulArMde}
\alias{KoulArMde}
\title{Minimum distance estimation in the autoregression model of the known order.}
\usage{
KoulArMde(X, AR_Order, IntMeasure, TuningConst = 1.345)
}
\arguments{
\item{X}{- Vector of \code{n} observed values.}

\item{AR_Order}{- Order of the autoregression model.}

\item{IntMeasure}{- Symmetric and \eqn{\sigma}-finite measure: Lebesgue, Degenerate, and Robust}

\item{TuningConst}{- Used only for Robust measure.}
}
\value{
rhohat     - Minimum distance estimator of \eqn{\rho}.

residual   - Residuals after minimum distance estimation.

ObjVal     - Value of the objective function at minimum distance estimator.
}
\description{
Estimates the autoressive coefficients in the \eqn{X_t = \rho' Z_t + \xi_t } where \eqn{Z_t} is the vector of \eqn{q} observations at times \eqn{t-1,...,t-q}.
}
\examples{
##### Generate stationary AR(2) process with 10 observations
n <- 10
q <- 2
rho <- c(-0.2, 0.8)    ##### Generate true parameters rho = (-0.2, 0.8)'
eps <- rnorm(n, 0,1)   ##### Generate innovations from N(0,1)
X <- rep(0, times=n)
for (i in 1:n){
 tempCol <- rep(0, times=q)
 for (j in 1:q){
   if(i-j<=0){
     tempCol[j] <- 0
   }else{
     tempCol[j] <- X[i-j]
   }
 }
X[i] <- t(tempCol)\%*\% rho + eps[i]
}

IntMeasure <- "Lebesgue"                       ##### Define Lebesgue measure

MDEResult <- KoulArMde(X, q, IntMeasure, TuningConst=1.345)
rhohat <- MDEResult$rhohat                     ##### Obtain minimum distance estimator
resid  <- MDEResult$residual                   ##### Obtain residual
objVal <- MDEResult$ObjVal                     ##### Obtain the value of the objective function


IntMeasure <- "Degenerate"                     ##### Define degenerate measure at 0
MDEResult <- KoulArMde(X, q, IntMeasure, TuningConst=1.345)
rhohat <- MDEResult$rhohat                     ##### Obtain minimum distance estimator
resid <- MDEResult$residual                    ##### Obtain residual
objVal <- MDEResult$ObjVal                     ##### Obtain the value of the objective function


IntMeasure <- "Robust"                         ##### Define "Robust" measure at 0
TuningConst <- 3                               ##### Define the tuning constant
MDEResult <- KoulArMde(X, q, IntMeasure, TuningConst)

resid <- MDEResult$residual                    ##### Obtain residual
objVal <- MDEResult$ObjVal                     ##### Obtain the value of the objective function

}
\references{
[1] Kim, J. (2018). A fast algorithm for the coordinate-wise minimum distance estimation. J. Stat. Comput. Simul., 3: 482 - 497

[2] Kim, J. (2020). Minimum distance estimation in linear regression model with strong mixing errors. Commun. Stat. - Theory Methods., 49(6): 1475 - 1494

[3] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3: 1-8.

[4] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[5] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulLrMde() and Koul2StageMde()
}
