% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_mode.R
\name{llm_fn_structured}
\alias{llm_fn_structured}
\title{Vectorized structured-output LLM}
\usage{
llm_fn_structured(
  x,
  prompt,
  .config,
  .system_prompt = NULL,
  ...,
  .schema = NULL,
  .fields = NULL,
  .local_only = FALSE,
  .validate_local = TRUE
)
}
\arguments{
\item{x}{A character vector \emph{or} a data.frame/tibble.}

\item{prompt}{A glue template string. With a data-frame you may reference
columns (\code{{col}}); with a vector the placeholder is \code{{x}}.}

\item{.config}{An \link{llm_config} object.}

\item{.system_prompt}{Optional system message (character scalar).}

\item{...}{Passed unchanged to \code{\link[=call_llm_broadcast]{call_llm_broadcast()}} (e.g. \code{tries},
\code{progress}, \code{verbose}).}

\item{.schema}{Optional JSON Schema list; if \code{NULL}, only JSON object is enforced.}

\item{.fields}{Optional fields to hoist from parsed JSON (supports nested paths).}

\item{.local_only}{If TRUE, do not send schema to the provider (parse/validate locally).}

\item{.validate_local}{If TRUE and \code{.schema} provided, validate locally.}
}
\description{
Schema-first variant of \code{\link[=llm_fn]{llm_fn()}}. It enables structured output on the config,
calls the model via \code{\link[=call_llm_broadcast]{call_llm_broadcast()}}, parses JSON, and optionally validates.
}
