% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper_Functions.R
\name{convert_age_to_thresh}
\alias{convert_age_to_thresh}
\title{Convert age to threshold}
\usage{
convert_age_to_thresh(
  age,
  dist = "logistic",
  pop_prev = 0.1,
  mid_point = 60,
  slope = 1/8,
  min_age = 10,
  max_age = 90,
  lower = stats::qnorm(0.05, lower.tail = FALSE),
  upper = Inf
)
}
\arguments{
\item{age}{A non-negative number representing the individual's age.}

\item{dist}{A string indicating which distribution to use.
If dist = "logistic", the logistic function will be used to
compute the age of onset.
If dist = "normal", the truncated normal distribution will be used instead.
Defaults to "logistic".}

\item{pop_prev}{Only necessary if dist = "logistic". A positive number representing the overall
population prevalence. Must be at most 1. Defaults to 0.1.}

\item{mid_point}{Only necessary if dist = "logistic". A positive number representing the mid point
logistic function. Defaults to 60.}

\item{slope}{Only necessary if dist = "logistic". A number holding the rate of increase.
Defaults to 1/8.}

\item{min_age}{Only necessary if dist = "normal". A positive number representing the individual's earliest age.
Defaults to 10.}

\item{max_age}{Only necessary if dist = "normal". A positive number representing the individual's latest age.
Must be greater than min_aoo. Defaults to 90.}

\item{lower}{Only necessary if dist = "normal". A number representing the lower cutoff point for the
truncated normal distribution. Defaults to 1.645
(stats::qnorm(0.05, lower.tail = FALSE)).}

\item{upper}{Only necessary if dist = "normal". A number representing the upper cutoff point of the
truncated normal distribution. Must be greater or equal to lower.
Defaults to Inf.}
}
\value{
If age is a positive number and all other necessary arguments are valid,
then \code{convert_age_to_thresh} returns a number, which is equal to
the threshold.
}
\description{
\code{convert_age_to_thresh} computes the threshold
from a person's age using either the logistic function
or the truncated normal distribution
}
\details{
Given a person's age, \code{convert_age_to_thresh} can be used
to first compute the cumulative incidence rate (cir), which is
then used to compute the threshold using either the
logistic function or the truncated normal distribution.
Under the logistic function, the formula used to compute
the threshold from an individual's age is given by
\deqn{qnorm(pop\_ prev / (1 + exp((mid\_ point - age) * slope)), lower.tail = F)},
while it is given by
\deqn{qnorm((1 - (age-min\_ age)/max\_ age) * (pnorm(upper) - pnorm(lower)) + pnorm(lower))}
under the truncated normal distribution.
}
\examples{
curve(sapply(age, convert_age_to_thresh), from = 10, to = 110, xname = "age")
}
