% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-arguments.R
\name{common-arguments}
\alias{common-arguments}
\title{Common arguments for several functions}
\arguments{
\item{y}{a numeric vector of real values (the observed data).}

\item{distname}{character; name of input distribution; see
\code{\link{get_distnames}}.}

\item{type}{type of Lambert W \eqn{\times} F distribution: skewed \code{"s"};
heavy-tail \code{"h"}; or skewed heavy-tail \code{"hh"}.}

\item{theta}{list; a (possibly incomplete) list of parameters \code{alpha},
\code{beta}, \code{gamma}, \code{delta}. \code{\link{complete_theta}}
fills in default values for missing entries.}

\item{beta}{numeric vector (deprecated); parameter \eqn{\boldsymbol \beta} of
the input distribution.  See \code{\link{check_beta}} on how to specify
\code{beta} for each distribution.}

\item{gamma}{scalar (deprecated); skewness parameter; default: \code{0}.}

\item{delta}{scalar or vector (length 2) (deprecated); heavy-tail
parameter(s); default: \code{0}.}

\item{alpha}{scalar or vector (length 2) (deprecated); heavy tail
exponent(s); default: \code{1}.}

\item{tau}{named vector \eqn{\tau} which defines the variable transformation.
Must have at least \code{'mu_x'} and \code{'sigma_x'} element; see
\code{\link{complete_tau}} for details.}

\item{return.u}{logical; if \code{TRUE}, it returns the standardized input
that corresponds to \eqn{U}, which is the zero-mean and/or unit-variance
version of input \eqn{X \sim F_X}.}

\item{use.mean.variance}{logical; if \code{TRUE} it uses mean and variance
implied by \eqn{\boldsymbol \beta} to do the transformation (Goerg 2011).
If \code{FALSE}, it uses the alternative definition from Goerg (2016)
with location and scale parameter.}
}
\description{
Reference list of most common function arguments in this package.
}
