% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap_table.R
\name{gap_table}
\alias{gap_table}
\title{Tabular summary of data and gaps in all groups}
\usage{
gap_table(
  dataset,
  Variable.colname = MEDI,
  Variable.label = "melanopic EDI",
  title = "Summary of available and missing data",
  Datetime.colname = Datetime,
  epoch = "dominant.epoch",
  full.days = TRUE,
  include.implicit.gaps = TRUE,
  check.irregular = TRUE,
  get.df = FALSE
)
}
\arguments{
\item{dataset}{A light logger dataset. Needs to be a dataframe.}

\item{Variable.colname}{Column name of the variable to check for NA values.
Expects a symbol.}

\item{Variable.label}{Clear name of the variable. Expects a string}

\item{title}{Title string for the table}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}

\item{epoch}{The epoch to use for the gapless sequence. Can be either a
\code{lubridate::duration()} or a string. If it is a string, it needs to be
either '"dominant.epoch"' (the default) for a guess based on the data or a
valid \code{lubridate::duration()} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{full.days}{If \code{TRUE}, the gapless sequence will include the whole first
and last day where there is data.}

\item{include.implicit.gaps}{Logical. Whether to expand the datetime sequence
and search for implicit gaps, or not. Default is \code{TRUE}. If no
\code{Variable.colname} is provided, this argument will be ignored. \strong{If there
are implicit gaps, gap calculation can be incorrect whenever there are
missing explicit gaps flanking implicit gaps!}}

\item{check.irregular}{Logical on whether to include irregular data in the
summary, i.e. data points that do not fall on the regular sequence.}

\item{get.df}{Logical whether the dataframe should be returned instead of a
\code{\link[gt:gt]{gt::gt()}} table}
}
\value{
A gt table about data and gaps in the dataset
}
\description{
\code{\link[=gap_table]{gap_table()}} creates a \code{\link[gt:gt]{gt::gt()}} with one row per group, summarizing key
gap and gap-related information about the dataset. These include the
available data, total duration, number of gaps, missing implicit and explicit
data, and, optionally, irregular data.
}
\examples{
sample.data.environment |> dplyr::filter(MEDI <= 50000) |> gap_table()
}
