% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_04_DE_1_SJ.R
\name{CompareValues.SJ.10x}
\alias{CompareValues.SJ.10x}
\title{Differential splice junction analysis}
\usage{
CompareValues.SJ.10x(
  MarvelObject,
  coord.introns = NULL,
  cell.group.g1,
  cell.group.g2,
  min.pct.cells.genes = 10,
  min.pct.cells.sj = 10,
  min.gene.norm = 1,
  seed = 1,
  n.iterations = 100,
  downsample = FALSE,
  show.progress = TRUE
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment.10x} function.}

\item{coord.introns}{Character strings. Specific splice junctions to be included for analysis. Default is \code{NULL}.}

\item{cell.group.g1}{Vector of Character strings. Cell IDs corresponding to Group 1 (reference group).}

\item{cell.group.g2}{Vector of Character strings. Cell IDs corresponding to Group 2.}

\item{min.pct.cells.genes}{Numeric value. Minimum percentage of cells in which the gene is expressed for that gene to be included for splice junction expression distribution analysis. Expressed genes defined as genes with non-zero normalised UMI counts. This threshold may be determined from \code{PlotPctExprCells.SJ.10x} function. Default is \code{10}.}

\item{min.pct.cells.sj}{Numeric value. Minimum percentage of cells in which the splice junction is expressed for that splice junction to be included for splice junction expression distribution analysis. Expressed splice junctions defined as splice junctions with raw UMI counts >= 1. This threshold may be determined from \code{PlotPctExprCells.SJ.10x} function. Default is \code{10}.}

\item{min.gene.norm}{Numeric value. The average normalised gene expression across the two cell groups above which the splice junction will be included for analysis. Default is \code{1.0}.}

\item{seed}{Numeric value. Random number generator to be fixed for permutations test and down-sampling.}

\item{n.iterations}{Numeric value. Number of times to shuffle the cell group labels when building the null distribution. Default is \code{100}.}

\item{downsample}{Logical value. If set to \code{TRUE}, both cell groups will be down-sampled so that both cell groups will have the same number of cells. The number of cells to downsample will be based on the smallest cell group. Default is \code{FALSE}.}

\item{show.progress}{Logical value. If set to \code{TRUE} (default), the progress bar will appear.}
}
\value{
An object of class S3 with a new slots \code{MarvelObject$DE$SJ$Table}, \code{MarvelObject$DE$SJ$cell.group.g1}, and \code{MarvelObject$DE$SJ$cell.group.g2}.
}
\description{
Performs differential splice junction analysis between two groups of cells.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define cell groups
    # Retrieve sample metadata
    sample.metadata <- marvel.demo.10x$sample.metadata

    # Group 1 (reference)
    index <- which(sample.metadata$cell.type=="iPSC")
    cell.ids.1 <- sample.metadata[index, "cell.id"]
    length(cell.ids.1)

    # Group 2
    index <- which(sample.metadata$cell.type=="Cardio day 10")
    cell.ids.2 <- sample.metadata[index, "cell.id"]
    length(cell.ids.2)

# DE
marvel.demo.10x <- CompareValues.SJ.10x(
                        MarvelObject=marvel.demo.10x,
                        cell.group.g1=cell.ids.1,
                        cell.group.g2=cell.ids.2,
                        min.pct.cells.genes=10,
                        min.pct.cells.sj=10,
                        min.gene.norm=1.0,
                        seed=1,
                        n.iterations=100,
                        downsample=TRUE,
                        show.progress=FALSE
                        )

# Check output
head(marvel.demo.10x$DE$SJ$Table)
}
