% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_07_PCA_2_RunPCA_Gene.R
\name{RunPCA.Exp}
\alias{RunPCA.Exp}
\title{Principle component analysis for gene Data}
\usage{
RunPCA.Exp(
  MarvelObject,
  sample.ids = NULL,
  cell.group.column,
  cell.group.order = NULL,
  cell.group.colors = NULL,
  features,
  min.cells = 25,
  point.size = 0.5,
  point.alpha = 0.75,
  point.stroke = 0.1
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{TransformExpValues} function.}

\item{sample.ids}{Character strings. Specific cells to plot.}

\item{cell.group.column}{Character string. The name of the sample metadata column in which the variables will be used to label the cell groups on the PCA.}

\item{cell.group.order}{Character string. The order of the variables under the sample metadata column specified in \code{cell.group.column} to appear in the PCA cell group legend.}

\item{cell.group.colors}{Character string. Vector of colors for the cell groups specified for PCA analysis using \code{cell.type.columns} and \code{cell.group.order}. If not specified, default \code{ggplot2} colors will be used.}

\item{features}{Character string. Vector of \code{gene_id} for analysis. Should match \code{gene_id} column of \code{MarvelObject$GeneFeature}.}

\item{min.cells}{Numeric value. The minimum no. of cells expressing the gene to be included for analysis.}

\item{point.size}{Numeric value. Size of data points on reduced dimension space.}

\item{point.alpha}{Numeric value. Transparency of the data points on reduced dimension space. Take any values between 0 to 1. The smaller the value, the more transparent the data points will be.}

\item{point.stroke}{Numeric value. The thickness of the outline of the data points. The larger the value, the thicker the outline of the data points.}
}
\value{
An object of class S3 containing with new slots \code{MarvelObject$PCA$Exp$Results}, \code{MarvelObject$PCA$Exp$Plot}, and \code{MarvelObject$PCA$Exp$Plot.Elbow}.
}
\description{
Performs principle component analysis using gene expression values.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

# Define genes for analysis
gene_ids <- marvel.demo$Exp$gene_id

# PCA
marvel.demo <- RunPCA.Exp(MarvelObject=marvel.demo,
                          sample.ids=marvel.demo$SplicePheno$sample.id,
                          cell.group.column="cell.type",
                          cell.group.order=c("iPSC", "Endoderm"),
                          min.cells=5,
                          features=gene_ids,
                          point.size=2
                          )

# Check outputs
head(marvel.demo$PCA$Exp$Results$ind$coord)
marvel.demo$PCA$Exp$Plot
}
