% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_04_PREPROCESS_2_SubsetSamples.R
\name{SubsetSamples}
\alias{SubsetSamples}
\title{Subset samples (cells)}
\usage{
SubsetSamples(MarvelObject, sample.ids)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject} function.}

\item{sample.ids}{Vector of character strings. Sample IDs to subset.}
}
\value{
An object of class S3 with updated slot \code{MarvelObject$SplicePheno}.
}
\description{
Subsets specific samples (cells) from sample metadata.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

sample.ids <- sample(marvel.demo$SplicePheno$sample.id, size=10)

marvel.demo <- SubsetSamples(MarvelObject=marvel.demo,
                             sample.ids=sample.ids
                             )
}
