% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_gain_curve}
\alias{plot_gain_curve}
\title{Plotting Gain Curve}
\usage{
plot_gain_curve(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
The \strong{plot_gain_curve()} function implements specialized visualizations for evaluating model effectiveness
in marketing and case selection contexts. The gain curve shows cumulative gains as a function of population
percentile, helping assess how well the model identifies high-value cases in ranked populations.
}
\examples{
# Note: For obtaining the gain curve plot the user needs to complete till fine_tuning( ) function
# of the MLwrap pipeline and only with categorical outcome.

\donttest{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well_bin ~ depression + emot_intel + resilience,
                             task = "classification")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Bayesian Optimization")

# And then, you can obtain the gain curve plot.

plot_gain_curve(wrap_object)

}

}
