% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-utils.R
\name{coeff_sel}
\alias{coeff_sel}
\title{Helps to select a given number of harmonics from a numerical vector.}
\usage{
coeff_sel(retain = 8, drop = 0, nb.h = 32, cph = 4)
}
\arguments{
\item{retain}{\code{numeric}. The number of harmonics to retain.}

\item{drop}{\code{numeric}. The number of harmonics to drop}

\item{nb.h}{\code{numeric}. The maximum harmonic rank.}

\item{cph}{\code{numeric}. Must be set to 2 for \code{rfourier} and
\code{tfourier} were used.}
}
\value{
\code{coeff_sel} returns indices that can be used to select columns
from an harmonic coefficient matrix. \code{coeff_split} returns a named list
of coordinates.
}
\description{
\code{coeff_sel} helps to select a given number of harmonics by returning
their indices when arranged as a numeric vector. For instance, harmonic
coefficients are arranged in the \code{$coe} slot of \code{\link{Coe}}-objects in
that way: \eqn{A_1, \dots, A_n, B_1, \dots, B_n, C_1, \dots, C_n, D_1,
\dots, D-n} after an elliptical Fourier analysis (see \link{efourier} and
\link{efourier}) while \eqn{C_n and D_n} harmonic are absent for radii
variation and tangent angle approaches (see \link{rfourier} and
\link{tfourier} respectively). . This function is used internally but might
be of interest elwewhere.
}
\examples{
bot.f <- efourier(bot, 32)
coe <- bot.f$coe # the raw matrix
coe
# if you want, say the first 8 harmonics but not the first one
retain <- coeff_sel(retain=8, drop=1, nb.h=32, cph=4)
head(coe[, retain])
}
