% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readModels.R
\name{readModels}
\alias{readModels}
\title{Read Parameters, Summary Statistics, and Savedata from Mplus Output}
\usage{
readModels(
  target = getwd(),
  recursive = FALSE,
  filefilter,
  what = "all",
  quiet = TRUE
)
}
\arguments{
\item{target}{the directory containing Mplus output files (.out) to
parse OR the single output file to be parsed. May be a full
path, relative path, or a filename within the working
directory. Defaults to the current working directory. Example:
"C:/Users/Michael/Mplus Runs"}

\item{recursive}{optional. If \code{TRUE}, parse all models nested in
subdirectories within \code{target}. Defaults to \code{FALSE}.}

\item{filefilter}{a Perl regular expression (PCRE-compatible)
specifying particular output files to be parsed within
\code{directory}. See \code{regex} or
\url{http://www.pcre.org/pcre.txt} for details about regular
expression syntax.}

\item{what}{a character vector denoting what aspects of Mplus output to extract.
Defaults to \code{"all"}, which will extract all supported output sections.
See details for additional information.}

\item{quiet}{whether to suppress printing to the screen the file currently
being processed. Defaults to TRUE.}
}
\value{
A list with one mplus.model per file. Each mplus.model object is composed of
elements containing major output sections, as detailed below. If
\code{target} is a single file, then the top-level elements will be
a single mplus.model object, not a list of files. Specific elements are:
  \item{input}{Mplus input syntax parsed into a list by major section}
  \item{warnings}{Syntax and estimation warnings as a list}
  \item{errors}{Syntax and estimation errors as a list}
  \item{data_summary}{Output of SUMMARY OF DATA section, including cluster sizes and ICCs}
  \item{sampstat}{Sample statistics provided by OUTPUT: SAMPSTAT, if specified}
  \item{covariance_coverage}{Covariance coverage matrix for checking missingness patterns}
  \item{summaries}{Summary statistics from \code{extractModelSummaries}, having structure as specified by that function}
  \item{parameters}{Model parameters from \code{extractModelParameters}, having structure as specified by that function}
  \item{class_counts}{Latent class counts and proportions for models that include a categorical latent variable}
  \item{indirect}{Output of MODEL INDIRECT if available in output. Contains \code{$overall} and \code{$specific} data.frames for each indirect effect section}
  \item{mod_indices}{Model modification indices from \code{extractModIndices}, having structure as specified by that function}
  \item{residuals}{a list containing relevant information from OUTPUT: RESIDUALS}
  \item{savedata_info}{File information about SAVEDATA files related to this output}
  \item{savedata}{SAVEDATA file as an R \code{data.frame}, as described in \code{getSavedata_Data}}
  \item{bparameters}{an \code{mcmc.list} object containing the draws from the MCMC chains for a Bayesian model that uses the
  	SAVEDATA: BPARAMETERS command}
  \item{tech1}{a list containing parameter specification and starting values from OUTPUT: TECH1}
  \item{tech3}{a list containing parameter covariance and correlation matrices from OUTPUT: TECH3}
  \item{tech4}{a list containing means, covariances, and correlations for latent variables from OUTPUT: TECH4}
  \item{tech7}{a list containing sample statistics for each latent class from OUTPUT: TECH7}
  \item{tech8}{a list containing optimization history of the model. Currently only supports potential scale reduction in BAYES. OUTPUT: TECH8}
  \item{tech9}{a list containing warnings/errors from replication runs for MONTECARLO analyses from OUTPUT: TECH9}
  \item{tech10}{a list containing model fit information from OUTPUT: TECH10}'   
  \item{tech12}{a list containing observed versus estimated sample statistics for TYPE=MIXTURE analyses from OUTPUT: TECH12}
  \item{fac_score_stats}{factor score mean, correlation, and covariance structure from SAMPLE STATISTICS FOR ESTIMATED FACTOR SCORES section}
  \item{lcCondMeans}{conditional latent class means and pairwise comparisons, obtained using auxiliary(e) syntax in latent class models}
  \item{gh5}{a list containing data from the gh5 (graphics) file corresponding to this output. (Requires rhdf5 package)}
  \item{output}{The entire, raw output file.}
}
\description{
Extracts information from one or more Mplus output files, including fit statistics and parameters.
Its is to parse all (supported) aspects of Mplus output and to combine
these into a list object, with one element per output file identified.
}
\details{
The \code{what} parameter defaults to "all", which extracts all supported output. If you would like to extract a
reduced set of output sections (especially to speed up the function when reading many files), specify the sections
as a character vector from the following options:

c("input", "warn_err", "data_summary", "sampstat", "covariance_coverage", "summaries",
     "parameters", "class_counts", "indirect", "mod_indices", "residuals",
     "savedata", "bparameters", "tech1", "tech3", "tech4", "tech7", "tech8",
     "tech9", "tech10", "tech12", "fac_score_stats", "lcCondMeans", "gh5",
     "output")
}
\examples{
\dontrun{
  allOutput <- readModels(
    "C:/Program Files/Mplus/Mplus Examples/User's Guide Examples", recursive=TRUE)
}
}
\author{
Michael Hallquist
}
\keyword{interface}
