% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbTocd.r
\name{cdTodb}
\alias{cdTodb}
\title{Convert cd/\eqn{\mbox{m}^2}{m^2} to perimetric dB.}
\usage{
cdTodb(cd, maxStim = 10000/pi)
}
\arguments{
\item{cd}{Value to convert to dB in cd/\eqn{\mbox{m}^2}{m^2}. Must be > 0.}

\item{maxStim}{Stimulus value for 0dB in cd/\eqn{\mbox{m}^2}{m^2}.}
}
\value{
A dB value for \code{cd} cd/\eqn{\mbox{m}^2}{m^2}.
}
\description{
Given a value in cd/\eqn{\mbox{m}^2}{m^2}, return the equivalent dB value.
Default is to use HFA units, so maximum stimulus is 10000 apostilbs.
}
\examples{
# candela to decibels
dB <- cdTodb(10000/pi)  # 0 dB
dB <- cdTodb(1000/pi)   # 10 dB
dB <- cdTodb(100/pi)    # 20 dB
dB <- cdTodb(10/pi)     # 30 dB
dB <- cdTodb(1/pi)      # 40 dB
dB <- cdTodb(0.1/pi)    # 50 dB
}
