% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSLdecomposition-package.R
\docType{package}
\name{OSLdecomposition-package}
\alias{OSLdecomposition-package}
\alias{OSLdecomposition}
\title{Signal Component Analysis for Optically Stimulated Luminescence}
\description{
Function library for the identification and separation of exponentially
decaying signal components in continuous-wave optically stimulated luminescence (CW-OSL) measurements.
A special emphasis is laid on luminescence dating with quartz, which is known for
systematic errors due to CW-OSL signal components with unequal physical behaviour.
Also, this package enables an easy to use signal decomposition of
CW-OSL data sets imported and analysed with the R package 'Luminescence'.
This includes the optional automatic creation of HTML reports.
}
\details{
\strong{Project website}
\itemize{
\item \url{https://luminescence.de}
}

\strong{Source code repository}
\itemize{
\item \url{https://github.com/DirkMittelstrass/OSLdecomposition}
}

\strong{Bug reporting}
\itemize{
\item \url{https://github.com/DirkMittelstrass/OSLdecomposition/issues}
}

\strong{This package is part of the RLum.Network}
\itemize{
\item \url{https://r-luminescence.org}
}

\strong{Package maintainer}

Dirk Mittelstraß, Independent researcher, Dresden (Germany),\cr
\email{dirk.mittelstrass@luminescence.de}

\strong{Citation}

Mittelstraß, D., Schmidt, C., Beyer, J., Heitmann, J. and Straessner, A.:
R package OSLdecomposition: Automated identification and separation of quartz CW-OSL signal components, \emph{in preparation}.

\strong{Funding}
Dirk Mittelstraß created this package as part of his master thesis and further enhanced and
published it as private endeavour. He did not receive any specific grant from funding agencies
in the public, commercial or not-for-profit sectors.
}
\keyword{package}
