% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_OSLcurves.R
\name{sum_OSLcurves}
\alias{sum_OSLcurves}
\title{Combine RLum OSL records to one global average curve}
\usage{
sum_OSLcurves(
  object,
  record_type = "OSL",
  aliquot_selection = NULL,
  offset_value = 0,
  verbose = TRUE,
  output.plot = FALSE,
  theme.set = ggplot2::theme_classic(),
  plot.first = FALSE,
  title = "default",
  filename = NULL
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} or \link{list} of \linkS4class{RLum.Analysis} (\strong{required}):
Data set of one or multiple aliquots containing CW-OSL records.}

\item{record_type}{\link{character} (\emph{with default}):
Type of records which are selected from the input \code{object},
for example: \code{"OSL"},\code{"SGOSL"} or \code{"IRSL"}.}

\item{aliquot_selection}{\link{numeric} vector (\emph{optional}):
Vector specifying the indices of elements (aliquots) of a list of \linkS4class{RLum.Analysis} objects
which shall be included.}

\item{offset_value}{\link{numeric} (\emph{with default}):
Signal offset (background) which will be subtracted from each record.}

\item{verbose}{\link{logical} (\emph{with default}):
Enables console text output.}

\item{output.plot}{\link{logical} (\emph{with default}):
returns a plot with all data points of all records and the average curve}

\item{theme.set}{\link{ggplot2} object (\emph{with default}):
sets the graphical theme of the output plot.
See \link[ggplot2:ggtheme]{ggplot2::theme_bw} for available themes}

\item{plot.first}{\link{logical} (\emph{with default}):
Plot includes additional drawing of first \code{record_type} record of first \code{object} list element.}

\item{title}{\link{character} (\emph{with default}):
Plot title. Set \code{title = "default"} for an automatically generated title.
Set \code{title = NULL} for no title.}

\item{filename}{\link{character} (\emph{optional}):
File name or path to save the plot as image. If just a file name is given, the image is
saved in the working directory. The image type is chosen by the file ending. Both, vector images
as well as pixel images are possible. Allowed are \code{.pdf}, \code{.eps}, \code{.svg} (vector graphics),
\code{.jpg}, \code{.png}, \code{.bmp} (pixel graphics) and more, see \link[ggplot2:ggsave]{ggplot2::ggsave}.}
}
\value{
A \link{data.frame} of the average CW-OSL curve is returned, containing two columns: \verb{$time} and \verb{$signal}.
}
\description{
This function adds up all CW-OSL records of the same type saved in \linkS4class{RLum.Analysis} objects and
calculates the arithmetic mean signal from all records for each channel.
This is useful to create global average curve with sufficient signal-to-noise ratio
for OSL components identification with \link{fit_OSLcurve} or to create a signal background
reference curve.
}
\section{Last updates}{


2020-10-30, DM: Overworked plotting; Expanded roxygen documentation
}

\examples{

# 'FB_10Gy' is a dose recovery test with the Fontainebleau quartz
# measured in a lexsyg research with green LED stimulation
data_path <- system.file("examples", "FB_10Gy_SAR.bin", package = "OSLdecomposition")
data_set <- Luminescence::read_BIN2R(data_path, fastForward = TRUE)

# Give average CW-OSL curve back
average_curve <- sum_OSLcurves(data_set)

}
\seealso{
\link{fit_OSLcurve}, \link{RLum.OSL_correction}, \link{RLum.OSL_global_fitting}
}
\author{
Dirk Mittelstraß, \email{dirk.mittelstrass@luminescence.de}

Please cite the package the following way:

Mittelstraß, D., Schmidt, C., Beyer, J., Heitmann, J. and Straessner, A.:
R package OSLdecomposition: Automated identification and separation of quartz CW-OSL signal components, \emph{in preparation}.
}
