% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockPatientProfiles.R
\name{mockPatientProfiles}
\alias{mockPatientProfiles}
\title{It creates a mock database for testing PatientProfiles package}
\usage{
mockPatientProfiles(
  con = NULL,
  writeSchema = NULL,
  numberIndividuals = 10,
  ...,
  seed = NULL
)
}
\arguments{
\item{con}{A DBI connection to create the cdm mock object.}

\item{writeSchema}{Name of an schema on the same connection with writing
permisions.}

\item{numberIndividuals}{Number of individuals to create in the cdm
reference.}

\item{...}{User self defined tables to put in cdm, it can input as many
as the user want.}

\item{seed}{A number to set the seed. If NULL seed is not used.}
}
\value{
A mock cdm_reference object created following user's specifications.
}
\description{
It creates a mock database for testing PatientProfiles package
}
\examples{
\donttest{
library(PatientProfiles)
library(CDMConnector)

cdm <- mockPatientProfiles()

mockDisconnect(cdm = cdm)
}

}
