% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_adapters.R
\name{load_mixed_symbols}
\alias{load_mixed_symbols}
\title{Load Mixed Symbols Including VIX}
\usage{
load_mixed_symbols(
  db_path,
  symbols,
  start_date,
  end_date,
  frequency = "weekly",
  use_adjusted = TRUE
)
}
\arguments{
\item{db_path}{Path to SQLite database}

\item{symbols}{Character vector including regular stocks and optionally "VIX"}

\item{start_date}{Start date for data}

\item{end_date}{End date for data}

\item{frequency}{Data frequency (default: "weekly")}

\item{use_adjusted}{Use adjusted prices (default: TRUE)}
}
\value{
data.table with all symbols properly loaded
}
\description{
Handles loading regular stocks and VIX together, with VIX loaded
separately without auto-update to avoid issues.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && file.exists("sp500.db")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
mixed <- load_mixed_symbols(
  db_path  = "sp500.db",
  symbols  = c("AAPL", "MSFT", "VIX"),
  start_date = "2020-01-01",
  end_date   = "2020-12-31",
  frequency  = "weekly"
)
head(mixed)
}
\dontshow{\}) # examplesIf}
}
