% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mcSetup.R
\name{plot.mcSetup}
\alias{plot.mcSetup}
\title{Plotting the Run-Off Triangle Increments by the MC Setting}
\usage{
\method{plot}{mcSetup}(x, ...)
}
\arguments{
\item{x}{an object of the class \code{mcSetup} -- i.e., the output
of the \code{incrExplor()} function}

\item{...}{other graphical parameters to plot}
}
\value{
The function returns a layout with two plots. ...
}
\description{
The function provides a graphical visualization of the results obtained from
the function \code{incrExplor()}. In particular, the considered run-off triangle
increments are distributed into the bins according the given Markov chain breaks
or states.
}
\examples{
## run-off triangle increments within the default bins
x <- incrExplor(CameronMutual)
plot(x)

## run-off triangle increments and user-defined number of bins
x <- incrExplor(CameronMutual, states = 5)
plot(x)

## run-off triangle increments within the user-specified bins
x <- incrExplor(CameronMutual, breaks = c(500, 1000, 1500))
plot(x)

}
\seealso{
\code{\link[=incrExplor]{incrExplor()}}, \code{\link[=mcReserve]{mcReserve()}}
}
