% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_study_info}
\alias{get_study_info}
\title{Get the Details/Metadata of the Current Active Study}
\usage{
get_study_info()
}
\value{
A data frame containing the metadata of the active study. Returns \code{NULL} 
if no study metadata is available.
}
\description{
Retrieves detailed metadata for the currently active study. The study must be 
set using the \code{\link{set_study}} function, and its details will be fetched 
from the BrAPI server.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  set_program("Wheat International Nurseries")
  set_trial("IDYT39")
  set_study("IDYT39 Environment Number 9")
  info <- get_study_info()
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, 
\code{\link{set_trial}}, \code{\link{set_study}} for related crop and study management.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
