% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_program}
\alias{set_program}
\title{Set the Current Active Breeding Program}
\usage{
set_program(program_name)
}
\arguments{
\item{program_name}{A string specifying the name of the breeding program to set as active.}
}
\value{
No return value. The internal state is updated with the selected program.
}
\description{
Updates the internal state to set the selected breeding program as active using the 
associated programDbId. This allows subsequent operations to be carried out 
within the context of this program.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()  # Log in to the server
  set_crop("wheat")  # Set crop
  set_program("Wheat International Nurseries")  # Set breeding program
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{list_programs}} for related operations in the crop and program selection process.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
